<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <style>
        *::-webkit-scrollbar {
            display: none;
        }

        * {
            -ms-overflow-style: none;
            /* IE and Edge */
            scrollbar-width: none;
            /* Firefox */
        }
    </style>
</head>

<body>
    <style>
        .date-show {
            font-family: sans-serif;
            font-weight: 350;
            font-size: 15px;
        }
    </style>
    <h2 class="date-show"></h2>
    <script>
        function updateDateTime() {
            const time = new Date();
            let textType = localStorage.getItem("textType") ? parseInt(localStorage.getItem("textType")) : 0;
            console.log(textType)
            const lastAccess = localStorage.getItem('lastAccess');
            const days = [
                "日", // minggu
                "月", // senin
                "火", // selasa
                "水", // rabu
                "木", // kamis
                "金", // Jum'at
                "土", // sabtu
            ];
            const months = [
                "01", // Mutsuki (Januari)
                "02", // Kisaragi (Februari)
                "03", // Yayoi (Maret)
                "04", // Uzuki (April)
                "05", // Satsuki (Mei)
                "06", // Minazuki (Juni)
                "07", // Fumizuki (Juli)
                "08", // Hazuki (Agustus)
                "09", // Nagatsuki (September)
                "10", // Kannazuki (Oktober)
                "11", // Shimotsuki (November)
                "12", // Shiwasu (Desember)
            ];

            let day = days[time.getDay()];
            let date = time.getDate();
            let year = time.getFullYear();
            let month = months[time.getMonth()];

            const texts = [`本日は ${year}年${month}月${date}日<span style="color:green;">(${day})</span> です。 `, `本日は ${year}年${month}月${date}日<span style="color:green;">(${day})</span>です。`]

            // let text = `本日は ${year}年${month}月${date}日<span style="color:brown;">(${day})</span> です。 `;

            // if (lastAccess) {
            //     const fakeTime = new Date(lastAccess);
            //     let fakeDate = fakeTime.getDate();
            //     let fakeYear = fakeTime.getFullYear();
            //     let fakeMonth = months[fakeTime.getMonth()];
            //     let fakeHour = fakeTime.getHours();
            //     let fakeMinute = fakeTime.getMinutes();

            //     text += `前回のアクセスは ${fakeYear}年${fakeMonth}月${fakeDate}日 ${fakeHour}時${fakeMinute}分 です。`;
            // }

            let text = texts[textType]


            if (lastAccess && textType == 0) {
                const fakeTime = new Date(lastAccess);
                let fakeDate = fakeTime.getDate();
                let fakeYear = fakeTime.getFullYear();
                let fakeMonth = months[fakeTime.getMonth()];
                let fakeHour = fakeTime.getHours();
                let fakeMinute = fakeTime.getMinutes();

                text += `前回のアクセスは ${fakeYear}年${fakeMonth}月${fakeDate}日 ${fakeHour}時${fakeMinute}分 です。`;
            }


            document.querySelector(".date-show").innerHTML = text;
            localStorage.setItem('lastAccess', time);
            if (textType >= texts.length - 1) {
                localStorage.setItem("textType", 0)
            } else {
                textType += 1;
                localStorage.setItem("textType", textType)
            }
        }
        window.addEventListener('load', updateDateTime);
        // setInterval(updateDateTime, 10000); // 10 detik, jika 10 menit maka 1000000
    </script>
</body>

</html>